<?php

namespace WPOauth2\Client;

trait OauthSettings {
	protected array $oauth_default_values;
	protected int $checked_basis = 1;
	protected int $checked_update = 0;
	protected int $checked_product = 0;
	protected int $checked_media = 0;
	protected int $checked_admin = 0;
	protected int $checked_super_admin = 0;
	protected string $cron_sync_interval = 'daily';
	protected bool $oauth2_cron_aktiv = true;
	protected string $authorize_uri = 'authorize';
	protected string $token_uri = 'token';

	protected string $well_known_url = '.well-known/jwks.json';
	protected string $api_get_client = 'api/get-client';
	protected string $api_remove_consent = 'api/remove-consent';
	protected string $select_user_role = 'manage_options';
	protected string $jwt_id = 'NjVBRjY5MDlCMUIwNzU4RTA2QzZFMDQ4QzQ2MDAyQjVDNjk1RTM2Qg';
    protected string $client_default_scopes = 'BASIC PRODUCT';

	protected function get_oauth_defaults( string $args = '', $id = null, $scope = null ): array {
		$this->oauth_default_values = [
			'oauth_settings'   => [
				'selected_user_role' => $this->select_user_role,
				'cron_sync_interval' => $this->cron_sync_interval,
				'oauth2_cron_aktiv' => $this->oauth2_cron_aktiv,
				'checked_basis' => $this->checked_basis,
				'checked_update' => $this->checked_update,
				'checked_product' => $this->checked_product,
				'checked_media' => $this->checked_media,
				'checked_admin' => $this->checked_admin,
				'checked_super_admin' => $this->checked_super_admin,
				'callback_url' => site_url(),
				'authorize_uri' => $this->authorize_uri,
				'token_uri' => $this->token_uri,
				'well_known_url' => $this->well_known_url,
				'client_scopes' => $this->client_default_scopes,
				'app_id' => '',
				'app_secret' => '',
				'server_url' => '',
			],
			'oauth_scopes' => [
				'0' => [
					'id' => 1,
					'scope' => 'BASIC',
					'value' => 'checked_basis',
					'standard' => true
				],
				'1' => [
					'id' => 2,
					'scope' => 'PRODUCT',
					'value' => 'checked_product',
					'standard' => false
				],
				'2' => [
					'id' => 3,
					'scope' => 'UPDATE',
					'value' => 'checked_update',
					'standard' => false
				],
				'3' => [
					'id' => 4,
					'scope' => 'MEDIA',
					'value' => 'checked_media',
					'standard' => false
				],
				'4' => [
					'id' => 5,
					'scope' => 'ADMIN',
					'value' => 'checked_admin',
					'standard' => false
				],
				'5' => [
					'id' => 6,
					'scope' => 'SUPER_USER',
					'value' => 'checked_super_admin',
					'standard' => false
				],
			],

			'select_user_role' => [
				"0" => [
					'value' => 'read',
					'name'  => __( 'Abonnent', 'wp-oauth2-client' )
				],
				"1" => [
					'value' => 'edit_posts',
					'name'  => __( 'Mitarbeiter', 'wp-oauth2-client' )
				],
				"2" => [
					'value' => 'publish_posts',
					'name'  => __( 'Autor', 'wp-oauth2-client' )
				],
				"3" => [
					'value' => 'publish_pages',
					'name'  => __( 'Redakteur', 'wp-oauth2-client' )
				],
				"4" => [
					'value' => 'manage_options',
					'name'  => __( 'Administrator', 'wp-oauth2-client' )
				],
			],
		];
		if ( $args ) {
			if ( $id ) {
				foreach ( $this->oauth_default_values[ $args ] as $tmp ) {
					if ( isset( $tmp['id'] ) && $tmp['id'] == $id ) {
						return $tmp;
					}
				}
			}

			if($scope){
				foreach ( $this->oauth_default_values[ $args ] as $tmp ) {
					if ( isset( $tmp['scope'] ) && $tmp['scope'] == $scope ) {
						return $tmp;
					}
				}
			}

			return $this->oauth_default_values[ $args ];
		} else {
			return $this->oauth_default_values;
		}
	}
}