<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wwdh.de
 * @since             1.0.0
 * @package           Wp_Oauth2_Client
 *
 * @wordpress-plugin
 * Plugin Name:       Hupa oAuth2 client
 * Plugin URI:        https://wwdh.de/plugins
 * Description:       WordPress Integration mit verschiedenen OAuth 2.0-Anbietern.
 * Version:           1.0.2
 * Author:            Jens Wiecker
 * Author URI:        https://wwdh.de
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wp-oauth2-client
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

const WP_OAUTH2_CLIENT_GIT_URL = 'https://github.com/team-hummelt/wp-oauth2-client';
/**
 * Plugin Database-Version.
 */
const WP_OAUTH2_CLIENT_DB_VERSION = '1.0.0';
/**
 * PHP minimum requirement for the plugin.
 */
const WP_OAUTH2_CLIENT_MIN_PHP_VERSION = '7.4';

/**
 * WordPress minimum requirement for the plugin.
 */
const WP_OAUTH2_CLIENT_MIN_WP_VERSION = '5.6';

const WP_OAUTH_CLIENT_CALLBACK_TEMPLATE_ID = '645f5d621e4f3';
/**
 * PLUGIN ROOT PATH.
 */
define('WP_OAUTH2_CLIENT_PLUGIN_DIR', dirname(__FILE__));
/**
 * PLUGIN URL.
 */
define('WP_OAUTH2_CLIENT_PLUGIN_URL', plugins_url('wp-oauth2-client') . '/');
/**
 * PLUGIN SLUG.
 */
define('WP_OAUTH2_CLIENT_SLUG_PATH', plugin_basename(__FILE__));
/**
 * PLUGIN Basename.
 */
define('WP_OAUTH2_CLIENT_BASENAME', plugin_basename(__DIR__));

if (is_file(WP_OAUTH2_CLIENT_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'config.json')) {
    $config = json_decode(file_get_contents(WP_OAUTH2_CLIENT_PLUGIN_DIR . DIRECTORY_SEPARATOR . 'config.json'), true);
    define("WP_OAUTH2_CLIENT_SERVER_URL", $config['server_url']);
    define("WP_OAUTH2_CLIENT_UPDATE_AKTIV", $config['update_aktiv']);
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wp-oauth2-client-activator.php
 */
function activate_wp_oauth2_client(): void
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-wp-oauth2-client-activator.php';
    Wp_Oauth2_Client_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wp-oauth2-client-deactivator.php
 */
function deactivate_wp_oauth2_client(): void
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-wp-oauth2-client-deactivator.php';
    Wp_Oauth2_Client_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_wp_oauth2_client');
register_deactivation_hook(__FILE__, 'deactivate_wp_oauth2_client');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-wp-oauth2-client.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wp_oauth2_client(): void
{

    $plugin = new Wp_Oauth2_Client();
    $plugin->run();

}

run_wp_oauth2_client();
