<?php

namespace WPOauth2\Client;

use stdClass;
use Wp_Oauth2_Client;

class Api_Product_Handle
{
    private static $instance;
    use OauthSettings;

    /**
     * @since    1.0.0
     * @var Wp_Oauth2_Client The main class.
     */
    protected Wp_Oauth2_Client $main;

    /**
     * The ID of this Plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $basename The ID of this theme.
     */
    protected string $basename;

    /**
     * @return static
     */
    public static function instance(string $basename, Wp_Oauth2_Client $main): self
    {
        if (is_null(self::$instance)) {
            self::$instance = new self($basename, $main);
        }

        return self::$instance;
    }

    public function __construct(string $basename, Wp_Oauth2_Client $main)
    {
        $this->main = $main;
        $this->basename = $basename;
    }

    public function fn_is_product_install($slug): bool
    {

        $all_plugins = get_plugins();
        if ($all_plugins) {
            foreach ($all_plugins as $key => $val) {
                if ($val['TextDomain'] == $slug) {
                    return true;
                }
            }
        }
        return false;
    }

    public function fn_is_theme_install($slug): bool
    {
        $theme_data = wp_get_theme($slug);
        if ($theme_data->exists()) {
            return true;
        } else {
            return false;
        }
    }

    public function fn_get_license_product_data($slug):array
    {
      $products = get_option($this->basename . '/lizenz_data');
      if($products) {
          foreach ($products as $tmp) {

              if ($tmp['config']['basename'] == $slug) {
                  return $tmp;
              }
          }
      }
      return [];
    }

    public function fn_download_lizenz_file($lizenz, $upload_token)
    {

    }

    public function fn_is_php_zip_extension(): bool
    {
        if (extension_loaded('zip')) {
            return true;
        }
        return false;
    }

    public function fn_install_hash_pin($pin): string
    {
        return password_hash($pin, PASSWORD_DEFAULT);
    }
}